#!/bin/sh

# this line gets fixed up by package-linux.sh
A8_SERVER_TARGET=

APP_NAME="Authentic8$A8_SERVER_TARGET client for Linux"
APP_VER="1.1.3"
INSTALL_PATH="$HOME/Authentic8$A8_SERVER_TARGET"
INSTALL_INFO_FILENAME=$HOME/.Authentic8$A8_SERVER_TARGET.install.log
LASTINSTALLPATH=""

# Make sure we're running in the same dir as the script
WORKDIR=`dirname $0`
test $WORKDIR = '' && WORKDIR=.
cd $WORKDIR

if [ -e $INSTALL_INFO_FILENAME ]; then
    . $INSTALL_INFO_FILENAME
fi

is_number()
{
    case $1 in
        ''|*[!0-9]*) return 0 ;;
        *) return 1 ;;
    esac
    return 0
}

show_missing_packages()
{
    MACHINE_TYPE=`uname -m`
    if [ $MACHINE_TYPE = 'x86_64' ]; then
        # 64-bit stuff here
        echo ""
        echo "Your machine needs the following apt packages installed before Authentic8 can be used."
        echo "If you have sudo privileges, run this command in a terminal:"
        echo "sudo apt-get install libc6:i386 libncurses5:i386 libstdc++6:i386 libz1:i386 libexpat1:i386 libgtk2.0-0:i386 libXxf86vm1:i386 libSM6:i386 libXv1:i386 libxkbfile1:i386"
        echo "If not, have your IT department install them for you."
        echo ""
        return 0
    else
        # 32-bit stuff here
        return 1
    fi
    return 1
}

install_client()
{
    echo "installing to $INSTALL_PATH"

    if [ -d $INSTALL_PATH ]; then
        echo "directory exist, not creating"
    else
        echo "directory does not exist, creating"
        mkdir $INSTALL_PATH
        if [ ! -d $INSTALL_PATH ]; then
            echo "failed to create directory"
            return 1
        fi
    fi

    echo "copying files"
    cp -a client/* $INSTALL_PATH
    cp icon_32x32.png $INSTALL_PATH
    if [ $? -eq 0 ]; then
        if [ -e $INSTALL_PATH/a8cli ]; then
            echo "install succeeded"
        else
            echo "install failed"
            return 1
        fi
    else
        echo "install failed"
        return 1
    fi
    
    echo "setting permissions"
    chmod +x "$INSTALL_PATH/a8cli"
    if [ $? -ne 0 ]; then
        echo "setting $INSTALL_PATH/a8cli permissions failed"
        return 1
    fi
    ldd $INSTALL_PATH/a8cli > /dev/null 2>&1
    if [ $? -ne 0 ]; then
        show_missing_packages
        if [ $? -eq 0 ]; then
            echo "Continue"
        else
            echo "ldd $INSTALL_PATH/a8cli failed"
            return 1
        fi
    fi
    # save the install path so we can uninstall it
    echo "LASTINSTALLPATH=$INSTALL_PATH" > $INSTALL_INFO_FILENAME

    return 0
}

remove_client()
{
    if [ "$LASTINSTALLPATH" != "" ]; then
        echo "removing $LASTINSTALLPATH"
        echo "Are you sure?  Enter to proceed control c to quit"
        read dummy
        rm -rf $LASTINSTALLPATH
        rm -f $INSTALL_INFO_FILENAME
        rm -f $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    else
        echo "It does not appear that the Authentic8 client is installed, nothing to remove"
    fi
    return 0
}

ask_path()
{
    in_ask_path=""
    echo "Please enter the directory in which $APP_NAME is to be installed."
    echo -n "default: [$INSTALL_PATH]:"
    read in_ask_path
    echo ""
    if [ "$in_ask_path" != "" ]; then
        INSTALL_PATH=$in_ask_path
    fi
    return 0
}

desktop_icon()
{
    echo "Creating desktop icon"
    if [ ! -d "$HOME/Desktop" ]; then
        mkdir $HOME/Desktop
    fi
    echo "#!/usr/bin/env xdg-open"                  > $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "[Desktop Entry]"                         >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "Comment[en_US]="                         >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "Comment="                                >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "Exec=$INSTALL_PATH/a8cli.sh"             >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "GenericName[en_US]="                     >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "GenericName="                            >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "Icon=$INSTALL_PATH/icon_32x32.png"       >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "MimeType="                               >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "Name[en_US]=Authentic8$A8_SERVER_TARGET" >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "Name=Authentic8$A8_SERVER_TARGET"        >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "Path="                                   >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "StartupNotify=true"                      >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "Terminal=false"                          >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "TerminalOptions="                        >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "Type=Application"                        >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "X-DBUS-ServiceName="                     >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "X-DBUS-StartupType="                     >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "X-KDE-SubstituteUID=false"               >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    echo "X-KDE-Username="                         >> $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop
    chmod +x $HOME/Desktop/Authentic8$A8_SERVER_TARGET.desktop

    echo "#!/bin/sh"                                > $INSTALL_PATH/a8cli.sh
    echo "cd $INSTALL_PATH"                        >> $INSTALL_PATH/a8cli.sh
    echo "exec $INSTALL_PATH/a8cli"                >> $INSTALL_PATH/a8cli.sh
    chmod +x $INSTALL_PATH/a8cli.sh

    return 0
}

echo "$APP_NAME $APP_VER setup."

echo "Copyright 2014-2018 Authentic8, Inc. All rights reserved."
echo ""
echo "User install mode."
echo ""
echo "Select a setup option:"
echo ""
echo " 1. Install $APP_NAME $APP_VER"
echo " 2. Remove $APP_NAME $APP_VER"
echo " 3. Quit $APP_NAME $APP_VER setup"
echo ""
echo -n "Enter option number 1-3 [1]:"
read user_input
echo ""

if [ "$user_input" = "" ]; then
    user_input=1
fi

is_number $user_input
if [ $? -eq 0 ]; then
    echo "invalid input"
    exit 1
fi

if [ $user_input -eq 3 ]; then
    echo "Exiting"
    exit 0
fi

if [ $user_input -eq 2 ]; then
    echo "Removing..."
    remove_client
    exit 0
fi

if [ $user_input -eq 1 ]; then
    echo "Installing..."
    ask_path
    if [ $? -ne 0 ]; then
        echo "Error getting installation path"
        exit 1
    fi
    if [ ! "$LASTINSTALLPATH" = "" ]; then
        if [ "$INSTALL_PATH" = "$LASTINSTALLPATH" ]; then
            echo "installing over the top on an existing install"
        else
            echo "installing to new directory when already installed"
            echo "please uninstall and reinstall or delete $INSTALL_INFO_FILENAME"
            exit 1
        fi
    else
        echo "new install"
    fi
    install_client
    if [ $? -ne 0 ]; then
        echo "Installation failed"
        exit 1
    fi
    desktop_icon
    exit 0
fi

echo "invalid input"
exit 1
